<?php $__env->startSection('content'); ?>
    <div class="d-flex justify-content-end mb-3">
        <form action="">
            <div class="input-group">
                <input class="form-control form--control" name="search" type="text" value="<?php echo e(request()->search); ?>" placeholder="<?php echo app('translator')->get('Transaction ID / wallet'); ?>">
                <button class="input-group-text append-icon--btn">
                    <i class="las la-search"></i>
                </button>
            </div>
        </form>
    </div>
    <div class="dashboard-table">
        <table class="table--responsive--lg table">
            <thead>
                <tr>
                    <th><?php echo app('translator')->get('Time'); ?></th>
                    <th><?php echo app('translator')->get('Transaction ID'); ?></th>
                    <th><?php echo app('translator')->get('Wallet'); ?></th>
                    <th><?php echo app('translator')->get('Amount'); ?></th>
                    <th><?php echo app('translator')->get('Status'); ?></th>
                    <th><?php echo app('translator')->get('Action'); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $withdraws; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $withdrawal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td>
                            <?php echo e(showDateTime($withdrawal->created_at)); ?>

                        </td>
                        <td><?php echo e($withdrawal->trx); ?></td>
                        <td>
                            <span title="<?php echo e($withdrawal->userCoinBalance->wallet); ?>"><?php echo e(shortAddress($withdrawal->userCoinBalance->wallet)); ?></span>
                        </td>
                        <td>
                            <strong><?php echo e(showAmount($withdrawal->amount, 8, exceptZeros:true, currencyFormat:false)); ?> <?php echo e(strtoupper($withdrawal->userCoinBalance->miner->coin_code)); ?></strong>
                        </td>

                        <td>
                            <?php
                                echo $withdrawal->statusBadge;
                            ?>
                        </td>

                        <td>
                            <?php if($withdrawal->status == Status::PAYMENT_SUCCESS): ?>
                                <button class="btn btn--success detailBtn btn--xsm" data-admin_feedback="<?php echo e($withdrawal->admin_feedback); ?>"><i class="las la-desktop"></i></button>
                            <?php elseif($withdrawal->status == Status::PAYMENT_REJECT): ?>
                                <button class="btn btn--danger detailBtn btn--xsm" data-admin_feedback="<?php echo e($withdrawal->admin_feedback); ?>"><i class="las la-desktop"></i></button>
                            <?php else: ?>
                                <a class="btn btn--warning btn--xsm" href="<?php echo e(route('user.withdraw.preview', encrypt($withdrawal->id))); ?>"><i class="las la-desktop"></i></a>
                            <?php endif; ?>
                        </td>

                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td class="text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
        <?php echo e(paginateLinks($withdraws)); ?>

    </div>

    <div class="modal custom--modal fade" id="detailModal" role="dialog" tabindex="-1">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo app('translator')->get('Details'); ?></h5>
                    <button class="close" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="withdraw-detail"></div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        'use strict';
        (function($) {

            $('.detailBtn').on('click', function() {
                var modal = $('#detailModal');
                var feedback = $(this).data('admin_feedback');

                modal.find('.withdraw-detail').html(`<p> ${feedback} </p>`);
                modal.modal('show');
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/postalde/console.vevercapital.com/core/resources/views/templates/dark/user/withdraw/log.blade.php ENDPATH**/ ?>