<?php
    $content = getContent('login.content', true);
?>

<?php $__env->startSection('content'); ?>
    <section class="account section-bg py-100">
        <div class="container">
            <div class="row align-items-center gy-4">
                <div class="col-lg-5 d-lg-block d-none">
                    <div class="account-content">
                        <div class="account-content__thumb">
                            <img src="<?php echo e(frontendImage('login' , @$content->data_values->image, '420x410')); ?>" alt="Login">
                        </div>
                    </div>
                </div>
                <div class="col-lg-7 ps-lg-5">
                    <div class="contact-form">
                        <h3 class="account-title pb-3 text-center"> <?php echo e(__(@$content->data_values->title)); ?> </h3>
                        <form class="verify-gcaptcha" method="POST" action="<?php echo e(route('user.login')); ?>" autocomplete="off">
                            <?php echo csrf_field(); ?>
                            <div class="form-group">
                                <input class="form--control" name="username" type="text" value="<?php echo e(old('username')); ?>" placeholder="<?php echo app('translator')->get('Username'); ?>" required>
                            </div>

                            <div class="form-group">
                                <div class="input-group">
                                    <input class="form--control" id="your-password" name="password" type="password" placeholder="<?php echo app('translator')->get('Password'); ?>" required>
                                    <div class="password-show-hide fas fa-eye toggle-password" id="#your-password"></div>
                                </div>
                            </div>

                            <?php if (isset($component)) { $__componentOriginalff0a9fdc5428085522b49c68070c11d6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalff0a9fdc5428085522b49c68070c11d6 = $attributes; } ?>
<?php $component = App\View\Components\Captcha::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('captcha'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Captcha::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalff0a9fdc5428085522b49c68070c11d6)): ?>
<?php $attributes = $__attributesOriginalff0a9fdc5428085522b49c68070c11d6; ?>
<?php unset($__attributesOriginalff0a9fdc5428085522b49c68070c11d6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalff0a9fdc5428085522b49c68070c11d6)): ?>
<?php $component = $__componentOriginalff0a9fdc5428085522b49c68070c11d6; ?>
<?php unset($__componentOriginalff0a9fdc5428085522b49c68070c11d6); ?>
<?php endif; ?>

                            <div class="form-group">
                                <div class="d-flex flex-wrap justify-content-between align-items-center">
                                    <div class="form--check mb-0">
                                        <input class="form-check-input" id="rem-me" name="remember" type="checkbox">
                                        <label class="form-check-label mb-0" for="rem-me"><?php echo app('translator')->get('Remember Me'); ?></label>
                                    </div>
                                    <div>
                                        <a class="checkbox__forgot-pass text--base" href="<?php echo e(route('user.password.request')); ?>"><?php echo app('translator')->get('Forget Password'); ?></a>
                                    </div>
                                </div>
                            </div>

                            <button class="btn--base w-100" type="submit"> <?php echo app('translator')->get('Login'); ?> </button>
                        </form>

                        <?php if(gs('registration')): ?>
                            <div class="mt-3">
                                <p><?php echo app('translator')->get('Don\'t Have An Account?'); ?> <a class="text--base" href="<?php echo e(route('user.register')); ?>"><?php echo app('translator')->get('Register'); ?></a></p>
                            </div>
                        <?php endif; ?>
                        <?php if(@gs('socialite_credentials')->linkedin->status || @gs('socialite_credentials')->facebook->status == Status::ENABLE || @gs('socialite_credentials')->google->status == Status::ENABLE): ?>
                            <?php echo $__env->make($activeTemplate . 'partials.social_login', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        "use strict";

        function submitUserForm() {
            var response = grecaptcha.getResponse();
            if (response.length == 0) {
                document.getElementById('g-recaptcha-error').innerHTML =
                    `<span style="color:red;"><?php echo app('translator')->get('Captcha field is required.'); ?></span>`;
                return false;
            }

            return true;
        }

        function verifyCaptcha() {
            document.getElementById('g-recaptcha-error').innerHTML = '';
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/postalde/console.vevercapital.com/core/resources/views/templates/dark/user/auth/login.blade.php ENDPATH**/ ?>