<div class="dashboard-table">
    <table class="table--responsive--lg table">
        <thead>
            <tr>
                <th scope="col"><?php echo app('translator')->get('Plan'); ?></th>
                <th scope="col"><?php echo app('translator')->get('Price'); ?></th>
                <th scope="col"><?php echo app('translator')->get('Return /Day'); ?></th>
                <th scope="col"><?php echo app('translator')->get('Total Days'); ?></th>
                <th scope="col"><?php echo app('translator')->get('Remaining Days'); ?></th>
                <?php if(!request()->routeIs('user.plans.active')): ?>
                    <th scope="col"> <?php echo app('translator')->get('Status'); ?></th>
                <?php endif; ?>
                <th scope="col"> <?php echo app('translator')->get('Action'); ?></th>
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td><?php echo e($data->plan_details->title); ?></td>
                    <td>
                        <?php echo e(showAmount($data->amount)); ?>

                    </td>
                    <td>
                        <?php if($data->min_return_per_day == $data->max_return_per_day): ?>
                            <?php echo e(showAmount($data->min_return_per_day, 8, exceptZeros: true, currencyFormat: false)); ?>

                        <?php else: ?>
                            <?php echo e(showAmount($data->min_return_per_day, 8, exceptZeros: true, currencyFormat: false) . ' - ' . showAmount($data->max_return_per_day, 8, exceptZeros: true, currencyFormat: false)); ?>

                        <?php endif; ?>
                        <?php echo e(strtoupper($data->miner->coin_code)); ?>

                    </td>

                    <td><?php echo e($data->period); ?></td>
                    <td>
                        <?php echo e($data->period_remain); ?>

                    </td>
                    <?php if(!request()->routeIs('user.plans.active')): ?>
                        <td>
                            <?php
                                echo $data->statusBadge;
                            ?>
                        </td>
                    <?php endif; ?>
                    <td>
                        <button class="btn--base btn--xsm viewBtn"
                            data-date="<?php echo e(__(showDateTime($data->created_at, 'd M, Y'))); ?>"
                            data-trx="<?php echo e($data->trx); ?>" data-plan="<?php echo e($data->plan_details->title); ?>"
                            data-miner="<?php echo e($data->plan_details->miner); ?>"
                            data-speed="<?php echo e($data->plan_details->speed); ?>" data-price="<?php echo e(showAmount($data->amount)); ?>"
                            data-rpd="<?php if($data->min_return_per_day == $data->max_return_per_day): ?> <?php echo e(showAmount($data->min_return_per_day, 8, exceptZeros: true, currencyFormat: false)); ?> <?php else: ?> <?php echo e(showAmount($data->min_return_per_day, 8, exceptZeros: true, currencyFormat: false) . ' - ' . showAmount($data->max_return_per_day, 8, exceptZeros: true, currencyFormat: false)); ?> <?php endif; ?> <?php echo e(strtoupper($data->miner->coin_code)); ?>"
                            data-period=<?php echo e($data->period); ?> data-period_r=<?php echo e($data->period_remain); ?>

                            data-status="<?php echo e($data->status); ?>"
                            <?php if($data->status == 0): ?> data-order_id="<?php echo e(encrypt($data->id)); ?>" <?php endif; ?>><i
                                class="las la-desktop"></i>
                        </button>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td class="text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
    <div class="mt-4">
        <?php if($paginate): ?>
            <?php echo e(paginateLinks($orders)); ?>

        <?php endif; ?>
    </div>
</div>

<!-- Modal -->
<div class="modal custom--modal fade" id="viewModal" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content rounded-0">
            <div class="modal-header rounded-0">
                <h4 class="modal-title text-white"><?php echo app('translator')->get('Track Details'); ?></h4>
                <button class="close" data-bs-dismiss="modal" type="button" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <ul class="list-group">
                    <li class="list-group-item d-flex justify-content-between">
                        <span class="font-weight-bold"><?php echo app('translator')->get('Created At'); ?></span>
                        <span class="p-date"></span>
                    </li>

                    <li class="list-group-item d-flex justify-content-between">
                        <span class="font-weight-bold"><?php echo app('translator')->get('Plan Title'); ?></span>
                        <span class="plan-title"></span>
                    </li>
                    <li class="list-group-item d-flex justify-content-between">
                        <span class="font-weight-bold"><?php echo app('translator')->get('Plan Price'); ?></span>
                        <span class="plan-price"></span>
                    </li>

                    <li class="list-group-item d-flex justify-content-between">
                        <span class="font-weight-bold"><?php echo app('translator')->get('Miner'); ?></span>
                        <span class="miner-name"></span>
                    </li>

                    <li class="list-group-item d-flex justify-content-between">
                        <span class="font-weight-bold"><?php echo app('translator')->get('Speed'); ?></span>
                        <span class="speed"></span>
                    </li>

                    <li class="list-group-item d-flex justify-content-between">
                        <span class="font-weight-bold"><?php echo app('translator')->get('Return /Day'); ?></span>
                        <span class="plan-rpd"></span>
                    </li>

                    <li class="list-group-item d-flex justify-content-between">
                        <span class="font-weight-bold"><?php echo app('translator')->get('Total Days'); ?></span>
                        <span class="plan-period"></span>
                    </li>

                    <li class="list-group-item d-flex justify-content-between">
                        <span class="font-weight-bold"><?php echo app('translator')->get('Remaining Days'); ?></span>
                        <span class="plan-period-r"></span>
                    </li>
                </ul>
            </div>
            <div class="modal-footer">
                <a class="btn btn--base w-100" href=""><?php echo app('translator')->get('Pay Now'); ?></a>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('script'); ?>
    <script>
        'use strict';
        (function($) {
            $('.viewBtn').on('click', function() {
                var modal = $('#viewModal');

                let data = $(this).data();
                modal.find('.p-date').text(data.date);
                modal.find('.plan-title').text(data.plan);
                modal.find('.plan-price').text(data.price);
                modal.find('.miner-name').text(data.miner);
                modal.find('.speed').text(data.speed);
                modal.find('.plan-rpd').text(data.rpd);
                modal.find('.plan-period').text(data.period);
                modal.find('.plan-period-r').text(data.period_r);

                if (data.status == 0) {
                    modal.find('.modal-footer').show();
                    modal.find('.modal-footer a').attr('href',
                        `<?php echo e(route('user.payment', '')); ?>/${data.order_id}`);
                } else {
                    modal.find('.modal-footer').hide();
                }
                modal.modal('show');
            })
        })(jQuery)
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/postalde/console.vevercapital.com/core/resources/views/templates/dark/partials/purchased_plan.blade.php ENDPATH**/ ?>