<?php
    $content = getContent('plan.content', true);
    $miners = App\Models\Miner::with('activePlans')
        ->whereHas('activePlans')
        ->orderBy('name', 'ASC')
        ->get();
?>
<?php if(count($miners)): ?>
    <section class="plan py-100 section-bg">
        <div class="container">
            <div class="row">
                <div class="section-heading">
                    <h3 class="section-heading__title"><?php echo e(__(@$content->data_values->heading)); ?></h3>
                    <p class="section-heading__desc"><?php echo e(__(@$content->data_values->description)); ?></p>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-12">
                    <?php echo $__env->make($activeTemplate . 'partials.plan_card', ['miners' => $miners], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>
        </div>
    </section>
<?php endif; ?>
<?php /**PATH /home/postalde/console.vevercapital.com/core/resources/views/templates/dark/sections/plan.blade.php ENDPATH**/ ?>