<?php $__env->startSection('content'); ?>
    <section class="blog-details py-100">
        <div class="container">
            <div class="row gy-4">
                <div class="col-xl-9 col-lg-8 pe-xl-5">
                    <div class="blog-item">
                        <div class="blog-item__thumb blog-details">
                            <img class="transform-unset" src="<?php echo e(frontendImage('blog', @$blog->data_values->blog_image, '900x600')); ?>" alt="">
                            <span class="blog-item__date"> <span class="blog-item__date-icon"><i class="fas fa-calendar-alt"></i></span> <?php echo e(showDateTime($blog->created_at, 'd, M')); ?> </span>
                        </div>
                        <div class="blog-item__content">
                            <h4 class="blog-item__title"><?php echo e($blog->data_values->title); ?> </h4>
                            <?php echo $blog->data_values->description ?>

                            <div class="follow-us d-flex align-items-center mt-4 flex-wrap gap-2">
                                <h4 class="follow-title me-2 mb-0"> <?php echo app('translator')->get('Share On'); ?> </h4>
                                <ul class="social-list">
                                    <li class="social-list__item">
                                        <a class="social-list__link" href="http://www.facebook.com/sharer/sharer.php?u=<?php echo e(urlencode(url()->current())); ?>"><i class="lab la-facebook-f"></i></a>
                                    </li>

                                    <li class="social-list__item">
                                        <a class="social-list__link" href="https://twitter.com/intent/tweet?text=my share text&amp;url=<?php echo e(urlencode(url()->current())); ?>"><i class="lab la-twitter"></i></a>
                                    </li>

                                    <li class="social-list__item">
                                        <a class="social-list__link" href="http://www.linkedin.com/shareArticle?mini=true&amp;url=<?php echo e(urlencode(url()->current())); ?>"><i class="lab la-linkedin-in"></i></a>
                                    </li>

                                    <li class="social-list__item">
                                        <a class="social-list__link" href="https://www.instagram.com/?url=<?php echo e(urlencode(url()->current())); ?>"><i class="lab la-instagram"></i></a>
                                    </li>
                                </ul>
                            </div>

                            <div class="fb-comments mt-4" data-href="<?php echo e(url()->current()); ?>" data-width="" data-numposts="5"></div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-lg-4">
                    <div class="blog-sidebar">
                        <h5 class="blog-sidebar__title"> <?php echo app('translator')->get('Latest Blog'); ?> </h5>

                        <?php $__currentLoopData = $latestBlogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $latestBlog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="latest-blog">
                                <div class="latest-blog__thumb">
                                    <a href="<?php echo e(route('blog.details', $latestBlog->slug)); ?>"> <img src="<?php echo e(frontendImage('blog', 'thumb_' . @$latestBlog->data_values->blog_image, '300x200')); ?>" alt="<?php echo app('translator')->get('Blog'); ?>"></a>
                                </div>
                                <div class="latest-blog__content">
                                    <h6 class="latest-blog__title"><a href="<?php echo e(route('blog.details', $latestBlog->slug)); ?>"><?php echo e(strLimit($latestBlog->data_values->title, 40)); ?></a></h6>
                                    <span class="latest-blog__date"><?php echo e(showDateTime(@$latestBlog->created_at, $format = 'd F, Y')); ?></span>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/postalde/console.vevercapital.com/core/resources/views/templates/dark/blog_details.blade.php ENDPATH**/ ?>