<?php
    if (!@$class) {
        $class = 'col-xl-3 col-md-6 col-sm-8';
    }
?>
<div class="plan-tab">
    <?php if($miners?->count() > 1): ?>
        <ul class="nav custom--tab nav-pills mb-3" id="pills-tab" role="tablist">
            <?php $__currentLoopData = $miners; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li class="nav-item" role="presentation">
                    <button class="nav-link <?php if($loop->first): ?> active <?php endif; ?>" id="tabName<?php echo e($loop->iteration); ?>" data-bs-toggle="pill" data-bs-target="#pills-<?php echo e($loop->iteration); ?>" type="button" role="tab" aria-controls="pills-<?php echo e($loop->iteration); ?>" aria-selected="<?php if($loop->first): ?> true <?php else: ?> false <?php endif; ?>"><?php echo e($item->name); ?></button>
                </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    <?php endif; ?>
    <div class="tab-content" id="pills-tabContent">
        <?php $__currentLoopData = $miners; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="tab-pane fade <?php if($loop->first): ?> show active <?php endif; ?>" id="pills-<?php echo e($loop->iteration); ?>" role="tabpanel" aria-labelledby="tabName<?php echo e($loop->iteration); ?>">
                <div class="row gy-4 justify-content-center">
                    <?php $__currentLoopData = $item->activePlans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="<?php echo e($class); ?>">
                            <div class="price-item">
                                <div class="price-item__header">
                                    <h5 class="price-item__title"><?php echo e(__($plan->title)); ?></h5>
                                    <h2 class="price-item__price"> <?php echo e(gs('cur_sym') . showAmount($plan->price, currencyFormat: false)); ?><span class="price-item__price-month"> / <?php echo e($plan->period . ' ' . $plan->periodUnitText); ?></span> </h2>
                                </div>
                                <div class="price-item__content">
                                    <div class="price-item__body">
                                        <ul class="text-list">
                                            <li class="text-list__item"><?php echo app('translator')->get('Return per day:'); ?>
                                                <?php echo e(showAmount($plan->min_return_per_day, currencyFormat: false)); ?> <?php echo e(strtoupper($item->coin_code)); ?>

                                                <?php if($plan->max_return_per_day): ?>
                                                    - <?php echo e(showAmount($plan->max_return_per_day, currencyFormat: false)); ?> <?php echo e(strtoupper($item->coin_code)); ?>

                                                <?php endif; ?>
                                            </li>
                                            <li class="text-list__item"><?php echo e(getAmount($plan->maintenance_cost)); ?>% <?php echo app('translator')->get('Maintenance Cost Per Day'); ?></li>
                                            <?php $__currentLoopData = $plan->features ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li class="text-list__item"><?php echo e($feature); ?></li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    </div>
                                    <div class="price-item__button">
                                        <?php if(auth()->guard()->guest()): ?>
                                            <a class="btn--base" href="<?php echo e(route('user.login')); ?>"><?php echo app('translator')->get('Trade Now'); ?></a>
                                        <?php else: ?>
                                            <button class="btn--base buy-plan" data-id="<?php echo e($plan->id); ?>" data-title="<?php echo e($plan->title); ?>" data-price="<?php echo e(showAmount($plan->price, currencyFormat: false)); ?>" type="button"><?php echo app('translator')->get('Trade Now'); ?></button>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</div>

<?php if(auth()->guard()->check()): ?>
    <?php echo $__env->make($activeTemplate . 'partials.buy_plan_modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php endif; ?>
<?php /**PATH /home/postalde/console.vevercapital.com/core/resources/views/templates/dark/partials/plan_card.blade.php ENDPATH**/ ?>