<?php $__env->startSection('panel'); ?>
    <div class="row justify-content-center">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body p-0">

                    <div class="table-responsive--sm table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('Date'); ?></th>
                                    <th><?php echo app('translator')->get('Transaction Number'); ?></th>

                                    <?php if(!request()->routeIs('admin.users.withdrawals')): ?>
                                        <th><?php echo app('translator')->get('Username'); ?></th>
                                    <?php endif; ?>

                                    <th><?php echo app('translator')->get('Wallet'); ?></th>
                                    <th><?php echo app('translator')->get('Amount'); ?></th>

                                    <?php if(request()->routeIs('admin.withdraw.data.all')): ?>
                                        <th><?php echo app('translator')->get('Status'); ?></th>
                                    <?php endif; ?>

                                    <th><?php echo app('translator')->get('Action'); ?></th>

                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $withdrawals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $withdraw): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td>
                                            <?php echo e(showDateTime($withdraw->created_at)); ?>

                                        </td>
                                        <td class="fw-bold">
                                            <?php echo e($withdraw->trx); ?>

                                        </td>

                                        <?php if(!request()->routeIs('admin.users.withdrawals')): ?>
                                            <td>
                                                <a href="<?php echo e(route('admin.users.detail', $withdraw->user_id)); ?>"><?php echo e(@$withdraw->user->username); ?></a>
                                            </td>
                                        <?php endif; ?>

                                        <td>
                                            <span class="fw-bold"><?php echo e(@$withdraw->userCoinBalance->wallet); ?></span>
                                        </td>

                                        <td>
                                            <strong><?php echo e(showAmount($withdraw->amount, 8, exceptZeros: true, currencyFormat: false)); ?> <?php echo e(__(strtoupper($withdraw->userCoinBalance->miner->coin_code))); ?></strong>

                                        </td>

                                        <?php if(request()->routeIs('admin.withdraw.data.all')): ?>
                                            <td>
                                                <?php echo $withdraw->statusBadge ?>
                                            </td>
                                        <?php endif; ?>

                                        <td>
                                            <a href="<?php echo e(route('admin.withdraw.data.details', $withdraw->id)); ?>" class="btn btn-sm btn-outline--primary ms-1">
                                                <i class="la la-desktop"></i> <?php echo app('translator')->get('Details'); ?>
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                    </tr>
                                <?php endif; ?>

                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
                <?php if($withdrawals->hasPages()): ?>
                    <div class="card-footer py-4">
                        <?php echo e(paginateLinks($withdrawals)); ?>

                    </div>
                <?php endif; ?>
            </div><!-- card end -->
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
    <div class="d-inline">
        <select name="currency" class="form-control onChangeSubmit" form="search-form">
            <option value=""><?php echo app('translator')->get('All'); ?></option>
            <?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($item); ?>" <?php if(request()->currency == $item): echo 'selected'; endif; ?>><?php echo e($item); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>
    <?php if (isset($component)) { $__componentOriginale48b4598ffc2f41a085f001458a956d1 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginale48b4598ffc2f41a085f001458a956d1 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.search-form','data' => ['dateSearch' => 'yes','placeholder' => 'Username / TRX']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('search-form'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['dateSearch' => 'yes','placeholder' => 'Username / TRX']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginale48b4598ffc2f41a085f001458a956d1)): ?>
<?php $attributes = $__attributesOriginale48b4598ffc2f41a085f001458a956d1; ?>
<?php unset($__attributesOriginale48b4598ffc2f41a085f001458a956d1); ?>
<?php endif; ?>
<?php if (isset($__componentOriginale48b4598ffc2f41a085f001458a956d1)): ?>
<?php $component = $__componentOriginale48b4598ffc2f41a085f001458a956d1; ?>
<?php unset($__componentOriginale48b4598ffc2f41a085f001458a956d1); ?>
<?php endif; ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/postalde/console.vevercapital.com/core/resources/views/admin/withdraw/withdrawals.blade.php ENDPATH**/ ?>