<?php
    $content = getContent('transaction.content', true);
    $deposits = App\Models\Deposit::where('status', Status::PAYMENT_SUCCESS)
        ->with('user')
        ->orderBy('id', 'DESC')
        ->take(5)
        ->get();
    $withdraws = App\Models\Withdrawal::whereIn('status', [Status::PAYMENT_SUCCESS, Status::PAYMENT_PENDING])
        ->with('user', 'userCoinBalance.miner')
        ->orderBy('id', 'DESC')
        ->take(5)
        ->get();
?>

<section class="transaction py-100 section-bg">
    <div class="container">
        <div class="section-heading">
            <h3 class="section-heading__title"><?php echo e(__(@$content->data_values->heading)); ?></h3>
            <p class="section-heading__desc"><?php echo e(__(@$content->data_values->description)); ?></p>
        </div>
        <div class="row">
            <div class="col-lg-6 pe-lg-4">
                <div class="transaction-content">
                    <h3 class="transaction-content__title"><?php echo app('translator')->get('Latest Payments'); ?></h3>
                    <table class="table--responsive--lg table">
                        <thead class="bg--base">
                            <tr>
                                <th><?php echo app('translator')->get('User'); ?></th>
                                <th><?php echo app('translator')->get('Amount'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $deposits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deposit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td>
                                        <div class="user-info">
                                            <h6 class="user-info__name"><?php echo e($deposit->user->fullname); ?> </h6>
                                        </div>
                                    </td>
                                    <td><?php echo e(showAmount($deposit->amount)); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="col-lg-6 ps-lg-4">
                <div class="transaction-content right">
                    <h3 class="transaction-content__title text-end"><?php echo app('translator')->get('Latest Withdraws'); ?></h3>
                    <table class="table--responsive--lg table">
                        <thead class="bg--base">
                            <tr>
                                <th><?php echo app('translator')->get('User'); ?></th>
                                <th><?php echo app('translator')->get('Amount'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $withdraws; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $withdraw): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td data-label="User">
                                        <div class="user-info">
                                            <h6 class="user-info__name"><?php echo e($withdraw->user->fullname); ?></h6>
                                        </div>
                                    </td>
                                    <td data-label="Amount"><?php echo e(showAmount($withdraw->amount, 8, exceptZeros:true, currencyFormat:false)); ?> <?php echo e(strtoupper(@$withdraw->userCoinBalance->miner->coin_code)); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</section>
<?php /**PATH /home/postalde/console.vevercapital.com/core/resources/views/templates/dark/sections/transaction.blade.php ENDPATH**/ ?>