<?php $__env->startSection('content'); ?>
    <?php if($withdrawMethod->count()): ?>
        <div class="wallet-card-wrapper">
            <?php $__currentLoopData = $withdrawMethod; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="wallet-card">
                    <div class="wallet-card-body">

                        <div class="top flex-wrap">
                            <img alt="Image" class="logo" src="<?php echo e(getImage(getFilePath('miner') . '/' . $data->miner->coin_image, getFileSize('miner'))); ?>">
                            <div>
                                <h5 class="title"><?php echo e(strtoupper($data->miner->coin_code)); ?> <?php echo app('translator')->get('Wallet'); ?></h5>
                                <small><?php echo e(showAmount($data->balance, 8, exceptZeros: true, currencyFormat:false)); ?></strong> <?php echo e(strtoupper($data->miner->coin_code)); ?></small>
                            </div>

                            <div class="ms-sm-auto">
                                <button class="btn btn--sm btn--base withdrawBtn withdraw-btn" data-coin_code="<?php echo e(__(strtoupper($data->miner->coin_code))); ?>" data-id="<?php echo e($data->id); ?>" data-resource="<?php echo e($data); ?>" data-wallet_address="<?php echo e($data->wallet); ?>" type="button">
                                    <?php echo app('translator')->get('Withdraw Now'); ?>
                                </button>
                            </div>
                        </div>

                        <p class="address">
                            <span class="label"><?php echo app('translator')->get('Wallet Address'); ?></span>
                            <span class="value">
                                <?php if($data->wallet): ?>
                                    <?php echo e($data->wallet); ?>

                                <?php else: ?>
                                    <?php echo app('translator')->get('No wallet address provided yet'); ?>,
                                    <a class="text--base" href="<?php echo e(route('user.wallets')); ?>?coin_code=<?php echo e(strtoupper($data->miner->coin_code)); ?>">
                                        <?php echo app('translator')->get('Update now'); ?>
                                    </a>
                                <?php endif; ?>
                            </span>
                        </p>

                        <p class="address mt-3">
                            <span class="label"><?php echo app('translator')->get('Min Withdrawal Limit'); ?></span>
                            <span class="value">
                                <?php echo e(showAmount($data->miner->min_withdraw_limit, 8, exceptZeros: true, currencyFormat:false) . ' ' . strtoupper($data->miner->coin_code)); ?>

                            </span>
                        </p>

                        <p class="address mt-3">
                            <span class="label"><?php echo app('translator')->get('Max Withdrawal Limit'); ?></span>
                            <span class="value">
                                <?php echo e(showAmount($data->miner->max_withdraw_limit, 8, exceptZeros: true, currencyFormat:false) . ' ' . strtoupper($data->miner->coin_code)); ?>

                            </span>
                        </p>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    <?php else: ?>
        <div class="card custom--card">
            <div class="card-body">
                <h4 class="mb-0 text-center text--danger"><?php echo app('translator')->get('You did\'t have any wallet yet'); ?></h4>
            </div>
        </div>
    <?php endif; ?>
    <!-- Modal -->
    <div class="modal custom--modal fade" id="withdrawModal" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title method-name" id="exampleModalLabel"><?php echo app('translator')->get('Withdraw'); ?></h5>
                    <button aria-label="Close" class="close" data-bs-dismiss="modal" type="button">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="<?php echo e(route('user.withdraw.money')); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="col-12">
                            <div class="form-group">
                                <input class="form-control" name="id" type="hidden" value="">
                            </div>
                        </div>
                        <div class="col-12">
                            <label><?php echo app('translator')->get('Amount'); ?></label>
                            <div class="input-group">
                                <input class="form-control form--control" id="amount" name="amount" onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')" required="" type="text" value="<?php echo e(old('amount')); ?>">

                                <span class="input-group-text currency-addon"></span>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn--base w-100" type="submit"><?php echo app('translator')->get('Submit'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('style'); ?>
    <style>
        .custom--modal .modal-content {
            text-align: left !important;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('script'); ?>
    <script>
        'use strict';
        (function($) {
            $('.withdrawBtn').on('click', function() {
                let walletAddress = $(this).data('wallet_address');
                if (!walletAddress) {
                    notify('error', 'Please update your wallet address');
                    return;
                }
                var modal = $('#withdrawModal');
                modal.find('.currency-addon').text($(this).data('coin_code'));
                modal.find('input[name=id]').val($(this).data('id'))
                modal.modal('show');
            });

        })(jQuery)
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/postalde/console.vevercapital.com/core/resources/views/templates/dark/user/withdraw/methods.blade.php ENDPATH**/ ?>