<?php $__env->startSection('panel'); ?>
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body p-0">
                    <div class="table-responsive--sm table-responsive">
                        <table class="table--light style--two custom-data-table table">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('S.N.'); ?></th>
                                    <th><?php echo app('translator')->get('Order ID'); ?></th>
                                    <th><?php echo app('translator')->get('Plan Title'); ?></th>
                                    <th><?php echo app('translator')->get('Miner'); ?></th>
                                    <th><?php echo app('translator')->get('Price'); ?></th>
                                    <th><?php echo app('translator')->get('Period'); ?></th>
                                    <th><?php echo app('translator')->get('Retun /Day'); ?></th>
                                    <th><?php echo app('translator')->get('Status'); ?></th>
                                    <th><?php echo app('translator')->get('Action'); ?></th>
                                </tr>
                            </thead>
                            <tbody class="list">
                                <?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td> <?php echo e($orders->firstItem() + $loop->index); ?></td>
                                        <td> <?php echo e($order->trx); ?> </td>
                                        <td> <?php echo e(__($order->plan_details->title)); ?> </td>
                                        <td> <?php echo e(__($order->plan_details->miner)); ?> </td>
                                        <td> <?php echo e(showAmount($order->amount)); ?></td>
                                        <td> <?php echo e($order->plan_details->period); ?></td>
                                        <td>
                                            <?php echo e(showAmount($order->min_return_per_day, 8, exceptZeros:true, currencyFormat:false)); ?> - <?php echo e(showAmount($order->max_return_per_day, 8, exceptZeros:true, currencyFormat:false)); ?> <strong><?php echo e(strtoupper($order->miner->coin_code)); ?></strong>
                                        </td>
                                        <td>
                                            <?php
                                                echo $order->statusBadge;
                                            ?>
                                        </td>

                                        <td>
                                            <button class="btn btn-outline--primary btn-sm detailBtn" data-status_badge="<?php echo e($order->statusBadge); ?>" data-order="<?php echo e($order); ?>" data-purchase_date="<?php echo e(showDateTime($order->created_at)); ?>" data-plan_title="<?php echo e(__($order->plan_details->title)); ?>" data-plan_price="<?php echo e(showAmount($order->amount)); ?>" data-status="<?php echo e($order->status); ?>" data-deposit_id="<?php echo e(@$order->deposit->id); ?>" <?php if($order->status != Status::ORDER_UNPAID): ?> data-payment_via="<?php echo e(@$order->deposit ? @$order->deposit->methodName() : 'Wallet Balance'); ?>" <?php endif; ?>><i class="las la-desktop"></i><?php echo app('translator')->get('Detail'); ?></button>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                </div>
                <?php if($orders->hasPages()): ?>
                    <div class="card-footer py-4">
                        <?php echo e(paginateLinks($orders)); ?>

                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <div class="modal fade" id="detailModal" role="dialog" tabindex="-1">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo app('translator')->get('Details'); ?></h5>
                    <span class="close" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <i class="las la-times"></i>
                    </span>
                </div>
                <div class="modal-body">
                    <ul class="list-group list-group-flush userData mb-2">
                        <li class="list-group-item d-flex justify-content-between align-items-center px-0">
                            <span class="fw-bold"><?php echo app('translator')->get('Purchased At'); ?></span>
                            <span class="purchase-date"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center px-0">
                            <span class="fw-bold"><?php echo app('translator')->get('Plan Title'); ?></span>
                            <span class="plan-title"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center px-0">
                            <span class="fw-bold"><?php echo app('translator')->get('Price'); ?></span>
                            <span class="plan-price"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center payment-li px-0">
                            <span class="fw-bold"><?php echo app('translator')->get('Payment Via'); ?></span>
                            <span class="payment-via"></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center px-0">
                            <span class="fw-bold"><?php echo app('translator')->get('Status'); ?></span>
                            <span class="order-status"></span>
                        </li>
                    </ul>
                </div>
                <div class="modal-footer">
                    <a class="btn btn--primary w-100 h-45" href=""><?php echo app('translator')->get('Approve Payment'); ?></a>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
    <?php if (isset($component)) { $__componentOriginale48b4598ffc2f41a085f001458a956d1 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginale48b4598ffc2f41a085f001458a956d1 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.search-form','data' => ['placeholder' => 'Order ID']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('search-form'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['placeholder' => 'Order ID']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginale48b4598ffc2f41a085f001458a956d1)): ?>
<?php $attributes = $__attributesOriginale48b4598ffc2f41a085f001458a956d1; ?>
<?php unset($__attributesOriginale48b4598ffc2f41a085f001458a956d1); ?>
<?php endif; ?>
<?php if (isset($__componentOriginale48b4598ffc2f41a085f001458a956d1)): ?>
<?php $component = $__componentOriginale48b4598ffc2f41a085f001458a956d1; ?>
<?php unset($__componentOriginale48b4598ffc2f41a085f001458a956d1); ?>
<?php endif; ?>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            $('.detailBtn').on('click', function() {
                var modal = $('#detailModal');
                let data = $(this).data();

                modal.find('.purchase-date').html(data.purchase_date);
                modal.find('.plan-title').html(data.plan_title);
                modal.find('.plan-price').html(data.plan_price);
                if (data.status != <?php echo e(Status::ORDER_UNPAID); ?>) {
                    modal.find('.payment-li').removeClass('d-none');
                    modal.find('.payment-via').html(data.payment_via)
                } else {
                    modal.find('.payment-li').addClass('d-none');
                }

                if (data.status == <?php echo e(Status::ORDER_PENDING); ?>) {
                    modal.find('.modal-footer').removeClass('d-none');
                    modal.find('.modal-footer a').attr('href', `<?php echo e(route('admin.payment.details', '')); ?>/${data.deposit_id}`);
                } else {
                    modal.find('.modal-footer').addClass('d-none');
                }
                modal.find('.order-status').html(data.status_badge);
                modal.modal('show');
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/postalde/console.vevercapital.com/core/resources/views/admin/miner/order.blade.php ENDPATH**/ ?>